/****** Object:  StoredProcedure [dbo].[P_GERA_FECOP_EST_NF_ENT]    Script Date: 05/20/2013 17:10:48 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_FECOP_EST_NF_ENT]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_FECOP_EST_NF_ENT]
GO

--EXEC P_GERA_FECOP_EST_NF_ENT 1,1, '01/18/2016','01/18/2016',1,0

--VERSAO 2469
--EXEC P_GERA_FECOP_EST_NF_ENT 1,904,'20150525','20150525',0,1
CREATE PROCEDURE [dbo].[P_GERA_FECOP_EST_NF_ENT] (@CD_EMP INT, 
													   @CD_FILIAL INT, 
													   @DT_INI DATETIME,
													   @DT_FIM DATETIME, 
													   @VISUALIZAR INT = 0)  WITH ENCRYPTION  AS 

SET NOCOUNT ON 

CREATE TABLE #RsEntradasPis (CD_EMP              INT,
							CD_FILIAL			 INT,
							CD_NF				 INT,
							DT_ENT               DATETIME,
							SEQ_ITEM			 INT,
							CD_PROD				 INT,
							FECOP_RECALCULADO	 INT,
							PERC_ALIQ_FECOP		 MONEY,	
							ALIQ_ICMS_INTERNO    MONEY,
							PERC_ICMS_EST        MONEY)
 
--Gerando tabela inicial com o calculo padrao de PIS/COFINS
INSERT INTO #RsEntradasPis
SELECT
	EST_NF_ENT_IT.CD_EMP,
	EST_NF_ENT_IT.CD_FILIAL,
	EST_NF_ENT_IT.CD_NF,
	EST_NF_ENT.DT_ENT,
	EST_NF_ENT_IT.SEQ_ITEM,
	EST_NF_ENT_IT.CD_PROD,
	1 AS FECOP_RECALCULADO,
	ISNULL(EST_PROD_NCM_CADASTRO_COMB_POBREZA.PERC_ALIQ,0) AS PERC_ALIQ_FECOP,
    ALIQ_ICMS_INTERNO,
	A.PERC_ICMS_EST

 FROM  EST_NF_ENT
          INNER JOIN EST_NF_ENT_IT
          ON       EST_NF_ENT.Cd_Emp    = EST_NF_ENT_IT.Cd_Emp
          AND      EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
          AND      EST_NF_ENT.CD_NF     = EST_NF_ENT_IT.CD_NF
          INNER JOIN EST_PROD
          ON       EST_NF_ENT_IT.Cd_Emp  = EST_PROD.CD_emp
          AND      EST_NF_ENT_IT.CD_PROD = EST_PROD.CD_PROD
          INNER JOIN GLB_MOV_OP
          ON       EST_NF_ENT.Cd_Nt_Mov = GLB_MOV_OP.Cd_Mov_Op
          INNER JOIN EST_PROD_NCM_CADASTRO_COMB_POBREZA
          ON       EST_PROD_NCM_CADASTRO_COMB_POBREZA.NR_NCM = EST_PROD.NR_NCM
          INNER JOIN PRC_FILIAL
          ON       EST_NF_ENT.CD_EMP    = PRC_FILIAL.CD_EMP
          AND      EST_NF_ENT.CD_FILIAL = PRC_FILIAL.CD_FILIAL
          LEFT JOIN GLB_CID
          ON       PRC_FILIAL.CD_CID     = GLB_CID.CD_CID OUTER apply UFD_GLB_PESSOA (EST_NF_ENT.CD_FORN , GLB_MOV_OP.DEST_ORIG)V_GLB_PESSOA
		  LEFT JOIN EST_TRIB ON 
		  EST_NF_ENT_IT.CD_TRIB = EST_TRIB.CD_TRIB

		  OUTER APPLY UFD_EST_PROD_TRIB(EST_NF_ENT.CD_EMP,
          EST_NF_ENT.CD_FILIAL,   
          GLB_MOV_OP.CD_MOV_OP,
          EST_NF_ENT.CD_FORN,
          EST_NF_ENT_IT.CD_PROD,0,0,0,0,0,0,0,0,0)  A
          
WHERE
	EST_NF_ENT_IT.CD_EMP = @CD_EMP 
	AND EST_NF_ENT_IT.CD_FILIAL = @CD_FILIAL 
	AND EST_NF_ENT_IT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
	AND GLB_MOV_OP.TP_MOV IN (0,3)
	AND ISNULL(PROD_EXCESSAO_FECOP,0) = 0
	AND EST_PROD_NCM_CADASTRO_COMB_POBREZA.UF = GLB_CID.UF COLLATE SQL_Latin1_General_CP1_CI_AS  
	AND RIGHT(EST_TRIB.CD_TRIB_FC,2) in (10,70,60)
	
IF @VISUALIZAR =0 
begin
--Alterando a entrada de acordo com o novo calculo criado
UPDATE
	e
SET 
	
	e.FECOP_RECALCULADO = env.FECOP_RECALCULADO,
	
	e.PERC_FECOP = CASE WHEN  env.ALIQ_ICMS_INTERNO = env.PERC_ICMS_EST THEN
			env.PERC_ALIQ_FECOP
		ELSE
			0
		END   
FROM
	#RsEntradasPis env INNER JOIN EST_NF_ENT_IT e ON
	env.CD_EMP = e.CD_EMP AND
	env.CD_FILIAL = e.CD_FILIAL AND 
	env.CD_NF = e.CD_NF AND
	env.CD_PROD = e.CD_PROD AND
	env.DT_ENT = e.DT_ENT AND
	env.SEQ_ITEM = e.SEQ_ITEM 
end

IF @VISUALIZAR =1 
begin
	--Alterando a entrada de acordo com o novo calculo criado
	SELECT *
	FROM
		#RsEntradasPis  
end
DROP TABLE #RsEntradasPis;

--SELECT * FROM EST_NF_ENT_IT WHERE CD_EMP =1 
--AND CD_FILIAL = 1 
--AND CD_NF = 10295
--AND DT_ENT = '20160118'
--AND SEQ_ITEM =4
--AND CD_PROD = 37732
